/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog;

import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.app.comp.SplittedDlg;
import DE.siemens.ad.logo.dialog.JCalendarPanel;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.ProgramException;
import DE.siemens.ad.pdraw.simulation.OfflineInterpreter;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DateInputPanel
extends DataInputPanel {
    protected JSpinner fSpDate;
    protected JSpinner fSpTime;
    protected JLabel fLblDate;
    protected JLabel fLblTime;
    protected JButton fBtShowCalendar;
    private SpinnerDateModel fDateSpinnerModel;
    private OfflineInterpreter fInterpreter;
    private Date fSimulationTime;
    private SpinnerDateModel fTimeSpinnerModel;
    private JCheckBox fChxImmediatelyApplyValues;
    private JLabel fLblDatePreview;
    protected DateFormat fDateFormat = DateFormat.getDateTimeInstance(0, 2, Language.getLocale());

    public DateInputPanel(OfflineInterpreter interpreter) {
        this.fInterpreter = interpreter;
        this.initComponents();
        this.registerListeners();
    }

    private void registerListeners() {
        this.fBtShowCalendar.addActionListener(new ShowCalendarHandler());
        this.fSpDate.addChangeListener(new SpinnerChangeListener());
        this.fSpTime.addChangeListener(new SpinnerChangeListener());
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = null;
        this.fLblDate = new JLabel("Date");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.anchor = 13;
        this.add((Component)this.fLblDate, gbc);
        this.fLblTime = new JLabel("Time");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.anchor = 13;
        this.add((Component)this.fLblTime, gbc);
        this.fDateSpinnerModel = new SpinnerDateModel();
        this.fDateSpinnerModel.setCalendarField(6);
        this.fSpDate = new JSpinner(this.fDateSpinnerModel);
        SimpleDateFormat dateFormat = (SimpleDateFormat)DateFormat.getDateInstance(2, Language.getLocale());
        this.fSpDate.setEditor(new JSpinner.DateEditor(this.fSpDate, dateFormat.toPattern()));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.ipadx = 100;
        gbc.fill = 2;
        this.add((Component)this.fSpDate, gbc);
        this.fTimeSpinnerModel = new SpinnerDateModel();
        this.fTimeSpinnerModel.setCalendarField(12);
        this.fSpTime = new JSpinner(this.fTimeSpinnerModel);
        SimpleDateFormat timeFormat = (SimpleDateFormat)DateFormat.getTimeInstance(2, Language.getLocale());
        this.fSpTime.setEditor(new JSpinner.DateEditor(this.fSpTime, timeFormat.toLocalizedPattern()));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.ipadx = 100;
        gbc.fill = 2;
        this.add((Component)this.fSpTime, gbc);
        this.fBtShowCalendar = new JButton(Global.getIcon("/com/toedter/calendar/images/JCalendarColor16.gif"));
        this.fBtShowCalendar.setMargin(new Insets(0, 0, 0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.fill = 0;
        this.add((Component)this.fBtShowCalendar, gbc);
        this.fLblDatePreview = new JLabel();
        this.fLblDatePreview.setFont(this.fLblDatePreview.getFont().deriveFont(1));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(10, 5, 5, 5);
        gbc.gridwidth = 3;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        this.add((Component)this.fLblDatePreview, gbc);
        this.fChxImmediatelyApplyValues = new JCheckBox("Immediately apply values");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.insets = new Insets(15, 5, 5, 5);
        gbc.gridwidth = 3;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        this.add((Component)this.fChxImmediatelyApplyValues, gbc);
    }

    public String getTitle() {
        return Language.getString("dialog.setClock.title", "Set clock");
    }

    public void setLabels() {
        super.setLabels();
        this.fBtShowCalendar.setToolTipText(Language.getString("dialog.setClock.calendarButton.tooltip", "Show Calendar"));
        this.fLblDate.setText(Language.getString("dialog.setClock.date", "Date"));
        this.fLblTime.setText(Language.getString("dialog.setClock.time", "Time"));
        this.fChxImmediatelyApplyValues.setText(Language.getString("dialog.setClock.immediatelyApplyValues", "Immediately apply values"));
    }

    public void loadFieldContents() throws ProgramException {
        super.loadFieldContents();
        if (this.fInterpreter != null) {
            this.fSimulationTime = new Date(this.fInterpreter.getCurrentSimulationClockTime());
            this.fDateSpinnerModel.setValue(this.fSimulationTime);
            this.fTimeSpinnerModel.setValue(this.fSimulationTime);
        }
    }

    public void storeFieldContents() {
        super.storeFieldContents();
        if (this.fInterpreter != null) {
            this.fInterpreter.setCurrentSimulationTime(this.getDate().getTime());
        }
    }

    private Date getDate() {
        Calendar timeCalendar = Calendar.getInstance();
        timeCalendar.setTime((Date)this.fTimeSpinnerModel.getValue());
        Calendar returnCalendar = Calendar.getInstance();
        returnCalendar.setTime((Date)this.fDateSpinnerModel.getValue());
        returnCalendar.set(11, timeCalendar.get(11));
        returnCalendar.set(12, timeCalendar.get(12));
        returnCalendar.set(13, timeCalendar.get(13));
        return returnCalendar.getTime();
    }

    public class ShowCalendarHandler
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, DateInputPanel.this);
            if (window == null) {
                return;
            }
            JCalendarPanel calendarPanel = new JCalendarPanel();
            SplittedDlg splittedDlg = SplittedDlg.create(window, calendarPanel, 11);
            splittedDlg.show();
            if (splittedDlg.getControlPanel().getResult() == 1) {
                DateInputPanel.this.fDateSpinnerModel.setValue(calendarPanel.getCalendar().getTime());
            }
        }
    }

    public class SpinnerChangeListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent e) {
            if (DateInputPanel.this.fChxImmediatelyApplyValues.isSelected()) {
                DateInputPanel.this.storeFieldContents();
            }
            DateInputPanel.this.fLblDatePreview.setText(DateInputPanel.this.fDateFormat.format(DateInputPanel.this.getDate()));
        }
    }
}

